// Función para interceptar las respuestas de XMLHttpRequest
function interceptarXHR(callback) {
    // Guarda una referencia al constructor original
    var originalXhr = window.XMLHttpRequest;

    // Sobrescribe el constructor XMLHttpRequest
    window.XMLHttpRequest = function () {
        var xhr = new originalXhr();

        // Registra una función de retrollamada para el evento readystatechange
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.responseURL.includes('process')) {
                // 4 significa que la respuesta ha sido recibida completamente
                // y xhr.responseURL.includes('process') verifica si la URL de la solicitud contiene 'process'

                // Ejecuta la función de retrollamada pasando la instancia de XMLHttpRequest
                callback(xhr);
            }
        };

        return xhr;
    };
}

// Función de retrollamada para manejar las respuestas interceptadas
function manejarRespuesta(xhr) {
    // Verifica si la solicitud fue exitosa (estado de respuesta 200)
    if (xhr.status === 200) {
        // Guarda la respuesta en localStorage con el nombre 'response_prueba_vida'
        localStorage.setItem('response_prueba_vida', xhr.responseText);
        
        // Envía un mensaje al contenedor de iframe
        var mensaje = xhr.responseText; // Puedes enviar cualquier mensaje que desees aquí
        window.parent.postMessage(mensaje, '*'); // '*' indica que el mensaje puede ser recibido por cualquier origen
    }
}

// Llama a la función interceptarXHR para activar la interceptación
interceptarXHR(manejarRespuesta);

