<?php

function obtenerDataOcr($base64_sinTipoDato__ineFrontal = "", $base64_sinTipoDato__ineTrasera = "", $referencia = "", $current_date = "")
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'http://172.16.13.137:8089/ocr/capturar',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => '{
            "id": "' . $base64_sinTipoDato__ineFrontal . '",
            "idReverso": "' . $base64_sinTipoDato__ineTrasera . '",
            "referencia": "' . $referencia . '",
            "institucion": "DXN",
            "fecha": "' . $current_date . '"
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json; charset=UTF-8',
            'Authorization: Basic RFhOOkRYTjAxIQ=='
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        error_log('cURL error: ' . curl_error($curl));
        curl_close($curl);
        return false;
    }

    curl_close($curl);

    // Generar nombre de archivo basado en la hora actual y la referencia
    $filename = date('H-i-s') . '_' . $referencia . '.txt';
    $file = '/var/www/html/escaneo_ine_api/services/' . $filename;

    // Intentar escribir la respuesta en el archivo
    if (file_put_contents($file, $response) === false) {
        error_log('Failed to write to ' . $file);
        //echo 'Failed to write file';
        return false;
    } else {
        //echo 'File created successfully: ' . $file;
    }

    return json_decode($response, true);
}

