<?php


error_reporting(E_ALL);
ini_set('display_errors', 1);

$referencia = date("dmyHis");
$current_date = date("dmyHis00");

$siglas = "MSGP";

$path__INE__frente = $siglas . '/' . $siglas . '__INE__FRENTE.jpeg';
$path__INE__reverso = $siglas . '/' . $siglas . '__INE__REVERSO.jpeg';
//$path__ROSTRO = $siglas.'/'.$siglas.'__ROSTRO.jpeg';

$imagen_codificada__INE__frente = base64_encode(file_get_contents($path__INE__frente));
$imagen_codificada__INE__reverso = base64_encode(file_get_contents($path__INE__reverso));
//$imagen_codificada__ROSTRO = base64_encode(file_get_contents($path__ROSTRO));


$curl = curl_init();

curl_setopt_array($curl, array(
    CURLOPT_URL => '172.16.13.137:8089/ocr/capturar',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => '{
        "id": "' . $imagen_codificada__INE__frente . '",
        "idReverso": "' . $imagen_codificada__INE__reverso . '",
        "referencia": "' . $referencia . '",
        "institucion": "DXN",
        "fecha": "' . $current_date . '"
    }',
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json; charset=UTF-8',
        'Authorization: Basic RFhOOkRYTjAxIQ=='
    ),
));

$response = curl_exec($curl);

curl_close($curl);

$data = json_decode($response, true);



$datos_registro = explode(" ", $data['registro']);

$json_datos =
    [
        "versionJSON" => "V3.0",
        "datosCliente" => [
            "nombre" => $data['nombres'],
            "apellidoPaterno" => $data['primerApellido'],
            "apellidoMaterno" => $data['segundoApellido'],
            "ocr" => $data['ocr'],
            "anioRegistro" => $datos_registro[0],
            "anioEmision" => $data['emision'],
            "consentimiento" => "true",
            "numeroEmision" => $datos_registro[1],
            "claveElector" => $data['claveElector'],
            "cic" => $data['cic'],
            "curp" => $data['curp']
        ],
        "datosInstitucion" => [
            "idInstitucion" => "DXN",
            "idEstacion" => "ESTACION1",
            "fechaHora" => "20230313165135",
            "referencia" => $referencia,
            "latitud" => 33.679183,
            "longitud" => -17.76792,
            "codigoPostal" => "11510",
            "ciudad" => "CDMX",
            "estado" => "09"
        ],
        "datosMAFI" => [
            "nombreMAFI" => "MAFI MOVIL",
            "versionMAFI" => "V1.2",
            "tipoLector" => "WATSON MINI",
            "idParametros" => 2345,
            "tiempoLectura" => 234,
            "intentosLectura" => 1
        ]
    ];

echo "<pre>";
echo json_encode($json_datos);
