<?php

function guardarImagen($ineImage_base64 = "", $referencia = "", $tipo = "")
{

    // Verificar que la cadena base64 tiene un formato válido
    if (strpos($ineImage_base64, 'data:image/') === false || strpos($ineImage_base64, ';base64,') === false) {
        return null;
    }

    // Obtener la extensión de la imagen
    $mime_type = explode(';', explode(':', $ineImage_base64)[1])[0];
    $extension = isset(explode('/', $mime_type)[1]) ? explode('/', $mime_type)[1] : "png";

    // Decodificar la cadena base64
    $imageData = base64_decode(str_replace(' ', '+', str_replace('data:image/' . $extension . ';base64,', '', $ineImage_base64)));

    // Ruta donde deseas guardar la imagen (asegúrate de tener permisos de escritura)
    $nombreArchivo = $tipo . "_" . $referencia . "." . $extension;

    $ruta_completa = BASE_URL_INDIVIDUAL_FOLDER . '/' . $nombreArchivo;

    // Guardar la imagen en el archivo
    return (file_put_contents($ruta_completa, $imageData) ? $ruta_completa : null);
}
