<?php

function StartUp()
{
    $DB = [
        "HOST__DB" => "localhost",
        "USER__DB" => "postgres",
        "PASSWORD__DB" => "Roa@88071429",
        "NAME__DB" => "dxnine",
        "CHARSET__DB" => "utf8"
    ];
    $pdo = new PDO('pgsql:host=' . $DB["HOST__DB"] . ';dbname=' . $DB["NAME__DB"], $DB["USER__DB"], $DB["PASSWORD__DB"]);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    return $pdo;
}


function insertarRegistro($json_datos = [])
{
    $pdo = StartUp();
    $fecha_registro = date('Y-m-d H:i:s');
    
    // Preparar la consulta SQL
    $stmt = $pdo->prepare("
        INSERT INTO registro_cliente (
            version_json,
            fecha_registro,
            nombre_cliente,
            apellido_paterno,
            apellido_materno,
            ocr,
            anio_registro,
            anio_emision,
            consentimiento,
            numero_emision,
            clave_elector,
            cic,
            curp,
            id_institucion,
            id_estacion,
            fecha_hora_institucion,
            referencia,
            latitud,
            longitud,
            codigo_postal,
            ciudad,
            estado,
            nombre_mafi,
            version_mafi,
            tipo_lector,
            id_parametros,
            tiempo_lectura,
            intentos_lectura,
            rutaArchivoIneFrontal,
            rutaArchivoIneTrasera,
            fecha_nacimiento,
            colonia,
            validacion_mrz__fecha_nacimiento,
            validacion_mrz__sexo,
            validacion_mrz__vigencia,
            validacion_mrz__emision,
            validacion_mrz__cic,
            validacion_mrz__nombre,
            validacion_mrz__digito_validador,
            validacion_mrz__pais,
            validacion_mrz__numero_pasaporte,
            validacion_mrz__fecha_caducidad
        ) VALUES (
            :version_json,
            :fecha_registro,
            :nombre_cliente,
            :apellido_paterno,
            :apellido_materno,
            :ocr,
            :anio_registro,
            :anio_emision,
            :consentimiento,
            :numero_emision,
            :clave_elector,
            :cic,
            :curp,
            :id_institucion,
            :id_estacion,
            :fecha_hora_institucion,
            :referencia,
            :latitud,
            :longitud,
            :codigo_postal,
            :ciudad,
            :estado,
            :nombre_mafi,
            :version_mafi,
            :tipo_lector,
            :id_parametros,
            :tiempo_lectura,
            :intentos_lectura,
            :rutaArchivoIneFrontal,
            :rutaArchivoIneTrasera,
            :fecha_nacimiento,
            :colonia,
            :validacion_mrz__fecha_nacimiento,
            :validacion_mrz__sexo,
            :validacion_mrz__vigencia,
            :validacion_mrz__emision,
            :validacion_mrz__cic,
            :validacion_mrz__nombre,
            :validacion_mrz__digito_validador,
            :validacion_mrz__pais,
            :validacion_mrz__numero_pasaporte,
            :validacion_mrz__fecha_caducidad
        )
    ");

    $stmt->bindParam(":version_json", $json_datos['versionJSON']);
    $stmt->bindParam(":fecha_registro", $fecha_registro);
    $stmt->bindParam(":nombre_cliente", $json_datos['datosCliente']['nombre']);
    $stmt->bindParam(":apellido_paterno", $json_datos['datosCliente']['apellidoPaterno']);
    $stmt->bindParam(":apellido_materno", $json_datos['datosCliente']['apellidoMaterno']);
    $stmt->bindParam(":ocr", $json_datos['datosCliente']['ocr']);
    $stmt->bindParam(":anio_registro", $json_datos['datosCliente']['anioRegistro']);
    $stmt->bindParam(":anio_emision", $json_datos['datosCliente']['anioEmision']);
    $stmt->bindParam(":consentimiento", $json_datos['datosCliente']['consentimiento']);
    $stmt->bindParam(":numero_emision", $json_datos['datosCliente']['numeroEmision']);
    $stmt->bindParam(":clave_elector", $json_datos['datosCliente']['claveElector']);
    $stmt->bindParam(":cic", $json_datos['datosCliente']['cic']);
    $stmt->bindParam(":curp", $json_datos['datosCliente']['curp']);
    $stmt->bindParam(":id_institucion", $json_datos['datosInstitucion']['idInstitucion']);
    $stmt->bindParam(":id_estacion", $json_datos['datosInstitucion']['idEstacion']);
    $stmt->bindParam(":fecha_hora_institucion", $json_datos['datosInstitucion']['fechaHora']);
    $stmt->bindParam(":referencia", $json_datos['datosInstitucion']['referencia']);
    $stmt->bindParam(":latitud", $json_datos['datosInstitucion']['latitud']);
    $stmt->bindParam(":longitud", $json_datos['datosInstitucion']['longitud']);
    $stmt->bindParam(":codigo_postal", $json_datos['datosInstitucion']['codigoPostal']);
    $stmt->bindParam(":ciudad", $json_datos['datosInstitucion']['ciudad']);
    $stmt->bindParam(":estado", $json_datos['datosInstitucion']['estado']);
    $stmt->bindParam(":nombre_mafi", $json_datos['datosMAFI']['nombreMAFI']);
    $stmt->bindParam(":version_mafi", $json_datos['datosMAFI']['versionMAFI']);
    $stmt->bindParam(":tipo_lector", $json_datos['datosMAFI']['tipoLector']);
    $stmt->bindParam(":id_parametros", $json_datos['datosMAFI']['idParametros']);
    $stmt->bindParam(":tiempo_lectura", $json_datos['datosMAFI']['tiempoLectura']);
    $stmt->bindParam(":intentos_lectura", $json_datos['datosMAFI']['intentosLectura']);
    $stmt->bindParam(":rutaArchivoIneFrontal", $json_datos['image']['rutaArchivoIneFrontal']);
    $stmt->bindParam(":rutaArchivoIneTrasera", $json_datos['image']['rutaArchivoIneTrasera']);
    
    // Nuevos campos
    $stmt->bindParam(":fecha_nacimiento", $json_datos['datosCliente']['fechaNacimiento']);
    $stmt->bindParam(":colonia", $json_datos['datosCliente']['colonia']);
    
    // Campos de validacion_mrz
    $validacionMRZ = $json_datos['validacionMRZ'];
    $stmt->bindParam(":validacion_mrz__fecha_nacimiento", $validacionMRZ['fechaNacimiento']);
    $stmt->bindParam(":validacion_mrz__sexo", $validacionMRZ['sexo']);
    $stmt->bindParam(":validacion_mrz__vigencia", $validacionMRZ['vigencia']);
    $stmt->bindParam(":validacion_mrz__emision", $validacionMRZ['emision']);
    $stmt->bindParam(":validacion_mrz__cic", $validacionMRZ['cic']);
    $stmt->bindParam(":validacion_mrz__nombre", $validacionMRZ['nombre']);
    $stmt->bindParam(":validacion_mrz__digito_validador", $validacionMRZ['digitoValidador']);
    $stmt->bindParam(":validacion_mrz__pais", $validacionMRZ['pais']);
    $stmt->bindParam(":validacion_mrz__numero_pasaporte", $validacionMRZ['numeroPasaporte']);
    $stmt->bindParam(":validacion_mrz__fecha_caducidad", $validacionMRZ['fechaCaducidad']);

    // Ejecutar la consulta
    return $stmt->execute();
}



function obtenerRegistros()
{
    $pdo = StartUp();

    try {
        // Preparar la consulta SQL
        $stmt = $pdo->prepare("SELECT * FROM registro_cliente");

        // Ejecutar la consulta
        $stmt->execute();

        // Obtener los resultados
        $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Retornar los resultados como JSON
        header('Content-Type: application/json');
        echo json_encode($resultados);
    } catch (PDOException $e) {
        echo json_encode(["error" => $e->getMessage()]);
    }
}
